import random

# Ambiente: una griglia 5x5
stanza = [[random.choice(['pulito', 'sporco']) for _ in range(5)] for _ in range(5)]

print("Stato iniziale:")
for riga in stanza:
    print(riga)

posizione = (2, 2)      # centro della griglia
visitati = set()         # memorizza le posizioni già pulite o almeno visitate

def vicini(x,y):
    """ritorna celle adiacenti nei limiti"""
    return [(nx,ny) for nx,ny in [(x-1,y),(x+1,y),(x,y-1),(x,y+1)]
            if 0 <= nx < 5 and 0 <= ny < 5]

def agente(stanza, pos):
    x,y = pos

    # marca come visitata
    visitati.add((x,y))

    # se sporca → pulisci
    if stanza[x][y] == 'sporco':
        stanza[x][y] = 'pulito'
        print("Pulisco", (x,y))
        return (x,y)

    # altrimenti cerca tra i vicini un posto non visitato
    candidati = [p for p in vicini(x,y) if p not in visitati]
    if candidati:
        nx,ny = random.choice(candidati)
        print("Mi sposto verso non-visitata", (nx,ny))
        return (nx,ny)

    # fallback: tutto visitato intorno → movimento casuale valido
    nx,ny = random.choice(vicini(x,y))
    print("Mi sposto random", (nx,ny))
    return (nx,ny)

for _ in range(25):
    posizione = agente(stanza, posizione)

print("\nStato finale:")
for riga in stanza:
    print(riga)
print("Posizione finale:", posizione)
print("Celle visitate:", len(visitati))
